<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for tabs
*
* @package	postbit
*/
class vBDownloads_DataManager_Extension extends vB_DataManager
{
	/**
	* Array of recognised and required fields for tabs, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'extensionid' 			=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'extension' 			=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD),
		'mime' 					=> array(TYPE_STR, 		REQ_YES),
		'maxsize' 				=> array(TYPE_UINT, 	REQ_YES),
		'maxheight' 			=> array(TYPE_UINT, 	REQ_NO),
		'maxwidth' 				=> array(TYPE_UINT, 	REQ_NO),
		'isimage' 				=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 'verify_onoff'),
		'extensiongroupid' 		=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_downloads_extension';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('extensionid = \'%1$s\'', 'extensionid');

	/**
	* Verifies that the extensionid is valid
	*
	* @param	string	extensionid of the tab
	*
	* @return	boolean
	*/
	function verify_extension(&$extension)
	{
		global $vbphrase;
		
		$extension = strval($extension);
		if ($extension === '')
		{
			// Invalid
			return false;
		}

		if (!$this->condition OR $this->existing['extension'] != $extension)
		{
			// Check for existing download of this name
			if ($existing = VBDOWNLOADS::$db->fetchRow('
				SELECT extensionid
				FROM $dbtech_downloads_extension
				WHERE extension = ?', array($extension)
			))
			{
				// Whoopsie, exists
				$this->error('dbtech_downloads_x_already_exists_y', $vbphrase['dbtech_downloads_extension'], $extension);
				return false;
			}
		}

		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array(0, 1)) ? 1 : $onoff);
		
		return true;
	}

	/**
	* Verifies that the extensiongroupid is valid
	*
	* @param	string	extensiongroupid
	*
	* @return	boolean
	*/
	function verify_extensiongroupid(&$extensiongroupid)
	{
		// Validate extensiongroupid
		return is_array(VBDOWNLOADS::$cache['extensiongroup'][$extensiongroupid]);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_extensiondata_presave')) ? eval($hook) : false;		

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_extensiondata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_extensiondata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		VBDOWNLOADS_CACHE::build('extension');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_extensiondata_delete')) ? eval($hook) : false;
		
		// Rebuild the cache
		VBDOWNLOADS_CACHE::build('extension');
		
		return true;
	}
}